function Figure6C()
% Running this script produces the plot shown in Figure 6C and
% computes p-values.

%==========================================================================
% For each variable below, the top row gives data for PBS-treated samples
% (4 replicates each) and the bottom row gives data for osmotically-swollen
% samples (4 replicates each).
m101F_post = [0.035589 0.25576 0.06621 0.085076;
              0.065297 0.40263 0.1054 0.15252];
m5C4_pre = [0.18328 0.10906 0.21403 0.29247;
            0.22874 0.28032 0.33143 0.43365];
mADI_post = [0.074421 0.32732 0.079797 0.1633;
             0.12708 0.50843 0.16647 0.24326];
mCR9501_pre = [0.29452 0.16414 0.27427 0.33825;
               0.34687 0.34615 0.43466 0.54598];
mMot_post = [0.023012 0.074588 0.020884 0.02446;
             0.019823 0.14504 0.031037 0.031445];
mMot_pre = [0.14528 0.068461 0.12569 0.17611 ;
            0.19464 0.2534 0.20159 0.30494];
neg_post = [0.020153 0.02837 0.017098 0.044138 ;
            0.033566 0.026074 0.020955 0.015608];
neg_pre = [0.025129 0.025526 0.014967 0.0078443 ;
           0.028632 0.017454 0.0079189 0.0041261];
%==========================================================================

%==========================================================================
% Plot data for replicates and mean:
figure; hold on;
for k = 1:4
  q = 0;
  plot([q q+1],mCR9501_pre(:,k),'Color',[0.7 0.7 0.7]); q = q + 1.2;
  plot([q q+1],m5C4_pre(:,k),'Color',[0.7 0.7 0.7]); q = q + 1.2;
  plot([q q+1],mMot_pre(:,k),'Color',[0.7 0.7 0.7]); q = q + 1.2;
  plot([q q+1],neg_pre(:,k),'Color',[0.7 0.7 0.7]);
end
q = 0;
plot([q q+1],mean(mCR9501_pre,2),'k'); q = q + 1.2;
plot([q q+1],mean(m5C4_pre,2),'k'); q = q + 1.2;
plot([q q+1],mean(mMot_pre,2),'k'); q = q + 1.2;
plot([q q+1],mean(neg_pre,2),'k');
title('Pre-F particles')
xticks([0.5 1.7 2.9 4.1]);
xticklabels({'CR9501','5C4','Motav.','-IgG'});

figure; hold on;
for k = 1:4
  q = 0;
  plot([q q+1],mADI_post(:,k),'Color',[0.7 0.7 0.7]); q = q + 1.2;
  plot([q q+1],m101F_post(:,k),'Color',[0.7 0.7 0.7]); q = q + 1.2;
  plot([q q+1],mMot_post(:,k),'Color',[0.7 0.7 0.7]); q = q + 1.2;
  plot([q q+1],neg_post(:,k),'Color',[0.7 0.7 0.7]);
end
q = 0;
plot([q q+1],mean(mADI_post,2),'k'); q = q + 1.2;
plot([q q+1],mean(m101F_post,2),'k'); q = q + 1.2;
plot([q q+1],mean(mMot_post,2),'k'); q = q + 1.2;
plot([q q+1],mean(neg_post,2),'k');
title('Post-F particles')
xticks([0.5 1.7 2.9 4.1]);
xticklabels({'ADI-14359','101F','Motav.','-IgG'});
%==========================================================================

%==========================================================================
% Calculate and display p-values:       
[h,p] = ttest(mCR9501_pre(1,:),mCR9501_pre(2,:));
disp(['p-value for CR9501 pre-F comparison: ',num2str(p)]);
[h,p] = ttest(m5C4_pre(1,:),m5C4_pre(2,:));
disp(['p-value for 5C4 pre-F comparison: ',num2str(p)]);
[h,p] = ttest(mMot_pre(1,:),mMot_pre(2,:));
disp(['p-value for Motav pre-F comparison: ',num2str(p)]);
[h,p] = ttest(neg_pre(1,:),neg_pre(2,:));
disp(['p-value for -IgG pre-F comparison: ',num2str(p)]);

[h,p] = ttest(mADI_post(1,:),mADI_post(2,:));
disp(['p-value for ADI-14359 post-F comparison: ',num2str(p)]);
[h,p] = ttest(m101F_post(1,:),m101F_post(2,:));
disp(['p-value for 101F post-F comparison: ',num2str(p)]);
[h,p] = ttest(mMot_post(1,:),mMot_post(2,:));
disp(['p-value for Motav, post-F comparison: ',num2str(p)]);
[h,p] = ttest(neg_post(1,:),neg_post(2,:));
disp(['p-value for -IgG post-F comparison: ',num2str(p)]);
%==========================================================================